/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.util;

import ch.steph.apputil.User;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public abstract class PrintablePage
implements Printable {
    private Font titleFont;
    private Font normalFont;
    private int normalHeight;
    private FontMetrics normalFontMetrics;
    private Rectangle mainBounds;
    private Rectangle innerBounds;
    private String headerLeft;
    private String headerRight;
    private String footerLeft;
    private String footerRight;

    public void print(String string, int n) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setJobName(string);
        PageFormat pageFormat = printerJob.defaultPage();
        pageFormat.setOrientation(n);
        printerJob.setPrintable(this, pageFormat);
        if (User.instance().getProperty("NoPrintDialog", false)) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                System.out.println("Error printing direct: " + String.valueOf(printerException));
            }
        } else if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                System.out.println("Error printing: " + String.valueOf(printerException));
            }
        }
    }

    public void prepareHeader(Graphics graphics, PageFormat pageFormat, String string, String string2, String string3, String string4, String string5, int n) {
        this.headerLeft = string;
        this.headerRight = string2;
        this.footerLeft = string3;
        this.footerRight = string4;
        this.mainBounds = graphics.getClipBounds();
        int n2 = 10;
        int n3 = User.instance().getProperty("PrintBorderX", 0);
        int n4 = User.instance().getProperty("PrintBorderY", 0);
        this.mainBounds.x = this.mainBounds.x + 1 + n3;
        this.mainBounds.y = this.mainBounds.y + n2 + n4;
        this.mainBounds.width = this.mainBounds.width - 2 - n3;
        this.mainBounds.height = this.mainBounds.height - 2 * n2 - n4;
        this.normalFont = new Font(string5, 0, n);
        this.titleFont = new Font(string5, 1, n);
        this.normalFontMetrics = graphics.getFontMetrics(this.normalFont);
        this.normalHeight = this.normalFontMetrics.getHeight();
        if (this.normalHeight == 0) {
            this.normalHeight = User.instance().getProperty("printHeight", n + 2);
        } else {
            User.instance().setProperty("printHeight", this.normalHeight);
        }
        this.innerBounds = new Rectangle(this.mainBounds);
        if (string != null || string2 != null) {
            this.innerBounds.y += this.normalHeight;
            this.innerBounds.height -= this.normalHeight;
        }
        if (string3 != null || string4 != null) {
            this.innerBounds.height -= this.normalHeight;
        }
    }

    public void printHeader(Graphics graphics, PageFormat pageFormat, int n) {
        int n2;
        graphics.setFont(this.normalFont);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.normalFont);
        if (this.headerLeft != null) {
            graphics.drawString(this.headerLeft, this.mainBounds.x, this.mainBounds.y + this.normalHeight - this.getFontDescent());
        }
        if (this.headerRight != null) {
            n2 = fontMetrics.stringWidth(this.headerRight);
            graphics.drawString(this.headerRight, this.mainBounds.x + this.mainBounds.width - n2, this.mainBounds.y + this.normalHeight - this.getFontDescent());
        }
        if (this.footerLeft != null) {
            graphics.drawString(this.footerLeft, this.mainBounds.x, this.mainBounds.y + this.mainBounds.height - this.getFontDescent());
        }
        if (this.footerRight != null) {
            n2 = fontMetrics.stringWidth(this.footerRight);
            graphics.drawString(this.footerRight, this.mainBounds.x + this.mainBounds.width - n2, this.mainBounds.y + this.mainBounds.height - this.getFontDescent());
        }
        graphics.setClip(this.innerBounds.x, this.innerBounds.y, this.innerBounds.width, this.innerBounds.height);
        graphics.drawLine(this.innerBounds.x, this.innerBounds.y, this.innerBounds.x + this.innerBounds.width, this.innerBounds.y);
        graphics.drawLine(this.innerBounds.x, this.innerBounds.y + this.innerBounds.height, this.innerBounds.x + this.innerBounds.width, this.innerBounds.y + this.innerBounds.height);
    }

    public void printNormalLeft(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        int n5 = 0;
        if (n4 != this.normalHeight) {
            n5 = (n4 - this.normalHeight) / 2;
        }
        int n6 = n2 + n5 + this.normalHeight - this.getFontDescent();
        while (this.normalFontMetrics.stringWidth(string) > n3 && string.length() > 2) {
            string = string.substring(0, string.length() - 1);
        }
        graphics.drawString(string, n, n6);
    }

    public void printNormalCenter(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        int n5 = 0;
        if (n4 != this.normalHeight) {
            n5 = (n4 - this.normalHeight) / 2;
        }
        int n6 = n2 + n5 + this.normalHeight - this.getFontDescent();
        int n7 = (n3 - this.normalFontMetrics.stringWidth(string)) / 2;
        int n8 = n + n7;
        graphics.drawString(string, n8, n6);
    }

    public void printNormalRight(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        int n5 = 0;
        if (n4 != this.normalHeight) {
            n5 = (n4 - this.normalHeight) / 2;
        }
        int n6 = n2 + n5 + this.normalHeight - this.getFontDescent();
        int n7 = n3 - this.normalFontMetrics.stringWidth(string);
        int n8 = n + n7 - 1;
        graphics.drawString(string, n8, n6);
    }

    private int getFontDescent() {
        int n = this.normalFontMetrics.getDescent();
        if (n == 0) {
            int n2 = this.normalHeight / 5;
            n = User.instance().getProperty("printDescent", n2);
        } else {
            User.instance().setProperty("printDescent", n);
        }
        return n;
    }

    public Font getNormalFont() {
        return this.normalFont;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public Rectangle getInnerBounds() {
        return this.innerBounds;
    }

    public int getNormalHeight() {
        return this.normalHeight;
    }
}

