/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PwHelper {
    private static final int ITERATIONS = 61356;
    private static final int KEY_LENGTH = 256;
    private static final String ALGORITHM = "PBEWithSHA1AndDESede";
    private static final String SALT = "aP5.p5E/s0l5jdOIcA9";
    private static final Random random = new SecureRandom();

    public static String hashPassword(String string) {
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(string.toCharArray(), SALT.getBytes(), 61356, 256);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            byte[] byArray = secretKeyFactory.generateSecret(pBEKeySpec).getEncoded();
            return Base64.getEncoder().encodeToString(byArray);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            throw new RuntimeException("Error while hashing password", generalSecurityException);
        }
    }

    private static Stream<Character> getRandomBigChars(int n2) {
        IntStream intStream = random.ints(n2, 65, 90);
        return intStream.mapToObj(n -> Character.valueOf((char)n));
    }

    private static Stream<Character> getRandomSmallChars(int n2) {
        IntStream intStream = random.ints(n2, 97, 122);
        return intStream.mapToObj(n -> Character.valueOf((char)n));
    }

    private static Stream<Character> getRandomNumber(int n2) {
        IntStream intStream = random.ints(n2, 48, 57);
        return intStream.mapToObj(n -> Character.valueOf((char)n));
    }

    public static String generateSecureRandomPassword(int n) {
        Stream<Character> stream = Stream.concat(PwHelper.getRandomBigChars(n / 2), Stream.concat(PwHelper.getRandomSmallChars(n / 2), PwHelper.getRandomNumber(n / 2)));
        List list = stream.collect(Collectors.toList());
        Collections.shuffle(list);
        String string = list.stream().collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
        return string.substring(0, n);
    }
}

