/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class RtfEscape {
    private static final Charset charset = Charset.forName("Windows-1252");
    private static final CharsetEncoder charsetEncoder = charset.newEncoder();

    public static String escape(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuffer.append("\\par\n");
                    continue block7;
                }
                case '\t': {
                    stringBuffer.append("\\tab\n");
                    continue block7;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block7;
                }
                case '{': {
                    stringBuffer.append("\\{");
                    continue block7;
                }
                case '}': {
                    stringBuffer.append("\\}");
                    continue block7;
                }
                default: {
                    if (c < '\u007f') {
                        stringBuffer.append(c);
                        continue block7;
                    }
                    stringBuffer.append("\\u").append(Integer.toString(c)).append(RtfEscape.escapeWindows1252(c));
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String escapeWindows1252(char c) {
        if (!charsetEncoder.canEncode(c)) {
            return "" + c;
        }
        try {
            ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(String.valueOf(c)));
            int n = byteBuffer.get() & 0xFF;
            return String.format("\\'%02x", n);
        }
        catch (Exception exception) {
            return "" + c;
        }
    }
}

