/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;

public class TimeProbe
implements Serializable {
    private static final long serialVersionUID = -2949287848978535975L;
    private long startTime;
    private long lastTime;
    private long waitedUntilTime;
    private long waitingTime = 0L;
    private long waitCounter = 0L;
    private Hashtable<Integer, TimeEntry> entries = new Hashtable();

    public TimeProbe() {
        this.lastTime = this.startTime = new Date().getTime();
        this.waitedUntilTime = this.startTime;
    }

    public void partEnds(int n, String string) {
        TimeEntry timeEntry;
        Integer n2 = n;
        if (string.length() > 30) {
            string = string.substring(0, 30);
        }
        if (this.entries.containsKey(n2)) {
            timeEntry = this.entries.get(n2);
        } else {
            timeEntry = new TimeEntry(n, string);
            this.entries.put(n2, timeEntry);
        }
        ++timeEntry.count;
        long l = new Date().getTime();
        long l2 = l - this.lastTime;
        this.lastTime = l;
        timeEntry.sum += l2;
        if (l2 < timeEntry.min) {
            timeEntry.min = l2;
        }
        if (l2 > timeEntry.max) {
            timeEntry.max = l2;
        }
    }

    public void waitSinceLastTime(long l) {
        long l2 = new Date().getTime();
        this.waitedUntilTime += l;
        if (l2 < this.waitedUntilTime) {
            long l3 = this.waitedUntilTime - l2;
            try {
                Thread.sleep(l3);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++this.waitCounter;
            this.lastTime += l3;
            this.waitingTime += l3;
        }
    }

    public String getLogString() {
        if (this.entries.size() == 0) {
            this.lastTime = new Date().getTime();
        }
        StringBuilder stringBuilder = new StringBuilder(" Overall time: " + (this.lastTime - this.startTime) + "ms");
        if (this.waitingTime > 0L) {
            stringBuilder.append(", waited ").append(this.waitCounter).append(" times, waiting time: ").append(this.waitingTime).append("ms, running time: ").append(this.lastTime - this.startTime - this.waitingTime).append("ms");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.entries.keySet());
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            TimeEntry timeEntry = this.entries.get(iterator.next());
            if (timeEntry.description.length() <= n) continue;
            n = timeEntry.description.length();
        }
        for (Integer n2 : arrayList) {
            TimeEntry timeEntry = this.entries.get(n2);
            String string = "                              ".substring(0, n + 1 - timeEntry.description.length());
            stringBuilder.append("\n").append(timeEntry.description).append(string).append(": ").append(timeEntry.count).append(" times avg: ").append(timeEntry.sum / (long)timeEntry.count).append("ms, max: ").append(timeEntry.max).append("ms, min: ").append(timeEntry.min).append("ms, all: ").append(timeEntry.sum).append("ms");
        }
        return stringBuilder.toString();
    }

    public long getTimeSinceStart() {
        return new Date().getTime() - this.startTime;
    }

    protected static class TimeEntry {
        int sorter;
        String description;
        int count;
        long sum;
        long max;
        long min;

        TimeEntry(int n, String string) {
            this.sorter = n;
            this.description = string;
            this.count = 0;
            this.sum = 0L;
            this.max = 0L;
            this.min = Long.MAX_VALUE;
        }
    }
}

