/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class ZipUtil {
    static final String ZIP_ENCODING = "ISO-8859-1";

    public static byte[] compressBytesFast(byte[] byArray) throws IOException {
        Deflater deflater = new Deflater();
        deflater.setLevel(1);
        deflater.setInput(byArray);
        deflater.finish();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        byte[] byArray2 = new byte[1024];
        while (!deflater.finished()) {
            int n = deflater.deflate(byArray2);
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] compressBytesMost(byte[] byArray) throws IOException {
        Deflater deflater = new Deflater();
        deflater.setLevel(9);
        deflater.setInput(byArray);
        deflater.finish();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        byte[] byArray2 = new byte[1024];
        while (!deflater.finished()) {
            int n = deflater.deflate(byArray2);
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] decompressBytes(byte[] byArray) throws IOException {
        Inflater inflater = new Inflater();
        inflater.setInput(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        byte[] byArray2 = new byte[1024];
        while (!inflater.finished()) {
            try {
                int n = inflater.inflate(byArray2);
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            catch (DataFormatException dataFormatException) {
                dataFormatException.printStackTrace();
                return null;
            }
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] compressStringMost(String string) throws IOException {
        byte[] byArray = string.getBytes(ZIP_ENCODING);
        Deflater deflater = new Deflater();
        deflater.setLevel(9);
        deflater.setInput(byArray);
        deflater.finish();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        byte[] byArray2 = new byte[1024];
        while (!deflater.finished()) {
            int n = deflater.deflate(byArray2);
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static String decompressString(byte[] byArray) throws IOException {
        Inflater inflater = new Inflater();
        inflater.setInput(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        byte[] byArray2 = new byte[1024];
        while (!inflater.finished()) {
            try {
                int n = inflater.inflate(byArray2);
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            catch (DataFormatException dataFormatException) {
                dataFormatException.printStackTrace();
                return null;
            }
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toString(ZIP_ENCODING);
    }

    public static byte[] compressObjFast(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        return ZipUtil.compressBytesFast(byteArrayOutputStream.toByteArray());
    }

    public static byte[] compressObjMost(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        return ZipUtil.compressBytesMost(byteArrayOutputStream.toByteArray());
    }

    public static Object decompressObj(byte[] byArray) throws IOException, ClassNotFoundException {
        byte[] byArray2 = ZipUtil.decompressBytes(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        return object;
    }

    public static String bytesToZipHex(byte[] byArray) throws Exception {
        byte[] byArray2 = ZipUtil.compressBytesMost(byArray);
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray2) {
            stringBuilder.append(Integer.toString((by & 0xFF) + 256, 16).substring(1));
        }
        return stringBuilder.toString();
    }

    public static byte[] bytesFromZipHex(String string) throws Exception {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)Integer.parseInt("" + string.charAt(i * 2) + string.charAt(i * 2 + 1), 16);
        }
        return ZipUtil.decompressBytes(byArray);
    }
}

