/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.util.transfer;

import ch.steph.util.CryptService;
import ch.steph.util.Log;
import ch.steph.util.transfer.TransferObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TransferService {
    protected TransferService() {
    }

    public TransferObject encriptTransferFile(CryptService cryptService, String string, Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byte[] byArray2 = cryptService.encryptBytes(byArray);
            return new TransferObject(byArray2, string);
        }
        catch (Exception exception) {
            Log.write(2, "TransferService", "encrypt object ", exception);
            return null;
        }
    }

    public Object decriptTransferObject(CryptService cryptService, TransferObject transferObject) {
        try {
            byte[] byArray = cryptService.decryptBytes(transferObject.getTransfer());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            return object;
        }
        catch (Exception exception) {
            Log.write(2, "TransferService", "decrypt object ", exception);
            return null;
        }
    }
}

