/*
 * Decompiled with CFR 0.152.
 */
package com.hexidec.ekit.component;

import com.hexidec.util.Translatrix;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class FontSelectorDialog
extends JDialog
implements ItemListener {
    private Vector<String> vcFontnames = null;
    private final JComboBox jcmbFontlist;
    private String fontName = "";
    private JOptionPane jOptionPane;
    private final JTextPane jtpFontPreview;
    private String defaultText;

    public FontSelectorDialog(Frame frame, String string, boolean bl, String string2, String string3) {
        super(frame, string, bl);
        this.defaultText = string3 != null && string3.length() > 0 ? (string3.length() > 24 ? string3.substring(0, 24) : string3) : "aAbBcCdDeEfFgGhH,.0123";
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.vcFontnames = new Vector(stringArray.length - 5);
        for (String objectArray2 : stringArray) {
            if ("Dialog".equals(objectArray2) || "DialogInput".equals(objectArray2) || "Monospaced".equals(objectArray2) || "SansSerif".equals(objectArray2) || "Serif".equals(objectArray2)) continue;
            this.vcFontnames.add(objectArray2);
        }
        this.jcmbFontlist = new JComboBox<String>(this.vcFontnames);
        this.jcmbFontlist.addItemListener(this);
        this.jtpFontPreview = new JTextPane();
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        HTMLDocument hTMLDocument = (HTMLDocument)hTMLEditorKit.createDefaultDocument();
        this.jtpFontPreview.setEditorKit(hTMLEditorKit);
        this.jtpFontPreview.setDocument(hTMLDocument);
        this.jtpFontPreview.setMargin(new Insets(4, 4, 4, 4));
        this.jtpFontPreview.setBounds(0, 0, 120, 18);
        this.jtpFontPreview.setText(this.getFontSampleString(this.defaultText));
        Object[] objectArray3 = new Object[]{Translatrix.getTranslationString("FontSample"), this.jtpFontPreview, string2, this.jcmbFontlist};
        Object[] objectArray = new Object[]{Translatrix.getTranslationString("DialogAccept"), Translatrix.getTranslationString("DialogCancel")};
        this.jOptionPane = new JOptionPane(objectArray3, 3, 2, null, objectArray, objectArray[0]);
        this.setContentPane(this.jOptionPane);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                FontSelectorDialog.this.jOptionPane.setValue(-1);
            }
        });
        this.jOptionPane.addPropertyChangeListener(propertyChangeEvent -> {
            String string = propertyChangeEvent.getPropertyName();
            if (this.isVisible() && propertyChangeEvent.getSource() == this.jOptionPane && ("value".equals(string) || "inputValue".equals(string))) {
                Object object = this.jOptionPane.getValue();
                if (object == JOptionPane.UNINITIALIZED_VALUE) {
                    return;
                }
                this.jOptionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                this.fontName = object.equals(objectArray2[0]) ? (String)this.jcmbFontlist.getSelectedItem() : null;
                this.setVisible(false);
            }
        });
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.jtpFontPreview.setText(this.getFontSampleString(this.defaultText));
        }
    }

    public FontSelectorDialog(Frame frame, String string, boolean bl, String string2) {
        this(frame, string, bl, string2, "");
    }

    public String getFontName() {
        return this.fontName;
    }

    private String getFontSampleString(String string) {
        return "<HTML><BODY><FONT FACE=\"" + String.valueOf(this.jcmbFontlist.getSelectedItem()) + "\">" + string + "</FONT></BODY></HTML>";
    }
}

