/*
 * Decompiled with CFR 0.152.
 */
package com.hexidec.ekit.component;

import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

class ImageFileChooserPreview
extends JComponent
implements PropertyChangeListener {
    private static final int previewWidth = 100;
    private static final int previewHeight = 100;
    private ImageIcon imageThumb = null;
    private File imageFile = null;

    public ImageFileChooserPreview(JFileChooser jFileChooser) {
        this.setPreferredSize(new Dimension(100, 100));
        jFileChooser.addPropertyChangeListener(this);
    }

    public void loadImage() {
        if (this.imageFile == null) {
            this.imageThumb = null;
            return;
        }
        this.imageThumb = new ImageIcon(this.imageFile.getPath());
        if (this.imageThumb.getIconHeight() < 100 && this.imageThumb.getIconWidth() < 100) {
            return;
        }
        int n = 100;
        int n2 = 100;
        if (this.imageThumb.getIconHeight() > this.imageThumb.getIconWidth()) {
            n = -1;
        } else {
            n2 = -1;
        }
        this.imageThumb = new ImageIcon(this.imageThumb.getImage().getScaledInstance(n, n2, 1));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
            this.imageFile = (File)propertyChangeEvent.getNewValue();
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.imageThumb == null) {
            this.loadImage();
        }
        if (this.imageThumb == null) {
            return;
        }
        int n = (this.getWidth() - this.imageThumb.getIconWidth()) / 2;
        int n2 = (this.getHeight() - this.imageThumb.getIconHeight()) / 2;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n < 5) {
            n = 5;
        }
        this.imageThumb.paintIcon(this, graphics, n, n2);
    }
}

