/*
 * Decompiled with CFR 0.152.
 */
package com.rtfui;

import ch.steph.util.Log;
import com.rtfui.Messages;
import com.rtfui.dialog.ColorMenu;
import com.rtfui.dialog.FindDialog;
import com.rtfui.dialog.FontDialog;
import com.rtfui.dialog.ParagraphDialog;
import com.rtfui.help.RtfFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Date;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.rtf.RTFEditorKit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class RtfDocument
extends JPanel {
    private final RtfDocument rtfDocument;
    private JTextPane textArea;
    private StyledDocument document;
    private RTFEditorKit rtfEditorKit;
    private JComboBox<String> cbFonts;
    private JComboBox<String> cbSizes;
    private JToggleButton tbBold;
    private JToggleButton tbItalic;
    private JToggleButton tbUnderline;
    private JToggleButton tbStrike;
    private JToggleButton tbPghLeft;
    private JToggleButton tbPghCenter;
    private JToggleButton tbPghRight;
    private JToggleButton tbPghJustify;
    private String fontName = "";
    private int iFontSize = 0;
    private boolean skipUpdate;
    private int ixStart = -1;
    private int ixFinish = -1;
    private ColorMenu cmForeground;
    private Action undoAction;
    private Action redoAction;
    private UndoManager undoManager;
    private FontDialog fontDialog;
    private final GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
    private final String[] fontSizes = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    private final String[] fontNames = this.ge.getAvailableFontFamilyNames();
    private ParagraphDialog paragraphDialog;
    private FindDialog findDialog;
    private JFrame parentFrame;
    private String chooserFilePath = ".";
    private File chooserFile = null;
    private final CaretListener lsts = caretEvent -> this.showAttributesOnToolbar();
    private final FocusListener flst = new FocusListener(){

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (RtfDocument.this.ixStart >= 0 && RtfDocument.this.ixFinish >= 0) {
                if (RtfDocument.this.textArea.getCaretPosition() == RtfDocument.this.ixStart) {
                    RtfDocument.this.textArea.setCaretPosition(RtfDocument.this.ixFinish);
                    RtfDocument.this.textArea.moveCaretPosition(RtfDocument.this.ixStart);
                } else {
                    RtfDocument.this.textArea.select(RtfDocument.this.ixStart, RtfDocument.this.ixFinish);
                }
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            RtfDocument.this.ixStart = RtfDocument.this.textArea.getSelectionStart();
            RtfDocument.this.ixFinish = RtfDocument.this.textArea.getSelectionEnd();
        }
    };
    private Object saveLock = new Object();
    private String durationString;
    private Date durationStart = new Date();

    RtfDocument() {
        super(new BorderLayout());
        this.createPanel();
        this.rtfDocument = this;
    }

    void initialize(JFrame jFrame) {
        this.parentFrame = jFrame;
        this.document.addUndoableEditListener(new Undoer());
        this.fontDialog = new FontDialog(jFrame, this.fontNames, this.fontSizes);
        this.paragraphDialog = new ParagraphDialog(jFrame);
        this.showAttributesOnToolbar();
        this.textArea.grabFocus();
    }

    private void createPanel() {
        this.textArea = new JTextPane();
        this.rtfEditorKit = new RTFEditorKit();
        this.textArea.setEditorKit(this.rtfEditorKit);
        this.document = (StyledDocument)this.rtfEditorKit.createDefaultDocument();
        this.textArea.setDocument(this.document);
        this.add((Component)new JScrollPane(this.textArea), "Center");
        this.textArea.addCaretListener(this.lsts);
        this.textArea.addFocusListener(this.flst);
    }

    JMenuBar createMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(Messages.getString("rd18"));
        JMenu jMenu2 = new JMenu(Messages.getString("rd19"));
        JMenu jMenu3 = new JMenu(Messages.getString("rd20"));
        JMenu jMenu4 = new JMenu(Messages.getString("rd21"));
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        jMenuBar.add(jMenu4);
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("rd22"), new ImageIcon(this.getClass().getResource("/icons/action_file.png")));
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionEvent -> this.newDoc());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        JMenuItem jMenuItem2 = new JMenuItem(Messages.getString("rd24"), new ImageIcon(this.getClass().getResource("/icons/action_open.png")));
        jMenu.add(jMenuItem2);
        jMenuItem2.addActionListener(actionEvent -> this.openFileChooser());
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        JMenuItem jMenuItem3 = new JMenuItem(Messages.getString("rd26"), new ImageIcon(this.getClass().getResource("/icons/action_save.png")));
        jMenu.add(jMenuItem3);
        jMenuItem3.addActionListener(actionEvent -> this.saveFile());
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        JMenuItem jMenuItem4 = new JMenuItem(Messages.getString("rd28"), new ImageIcon(this.getClass().getResource("/icons/action_saveas.png")));
        jMenu.add(jMenuItem4);
        jMenuItem4.addActionListener(actionEvent -> this.saveFileWithChooser());
        JMenuItem jMenuItem5 = new JMenuItem(Messages.getString("rd30"), new ImageIcon(this.getClass().getResource("/icons/print.png")));
        jMenu.add(jMenuItem5);
        jMenuItem5.addActionListener(actionEvent -> this.printDocument());
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        jMenu.addSeparator();
        JMenuItem jMenuItem6 = new JMenuItem(Messages.getString("rd32"), new ImageIcon(this.getClass().getResource("/icons/action_close.png")));
        jMenu.add(jMenuItem6);
        jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        jMenuItem6.addActionListener(actionEvent -> this.exitAction());
        AbstractAction abstractAction = new AbstractAction(Messages.getString("rd37")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RtfDocument.this.textArea.cut();
            }
        };
        JMenuItem jMenuItem7 = jMenu2.add(abstractAction);
        jMenu2.add(jMenuItem7);
        jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        AbstractAction abstractAction2 = new AbstractAction(Messages.getString("rd34"), new ImageIcon(this.getClass().getResource("/icons/copy.png"))){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RtfDocument.this.textArea.copy();
            }
        };
        JMenuItem jMenuItem8 = jMenu2.add(abstractAction2);
        jMenu2.add(jMenuItem8);
        jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        AbstractAction abstractAction3 = new AbstractAction(Messages.getString("rd36"), new ImageIcon(this.getClass().getResource("/icons/paste.png"))){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RtfDocument.this.textArea.paste();
            }
        };
        JMenuItem jMenuItem9 = jMenu2.add(abstractAction3);
        jMenu2.add(jMenuItem9);
        jMenuItem9.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        jMenu2.addSeparator();
        this.undoManager = new UndoManager();
        this.undoAction = new AbstractAction(Messages.getString("rd38"), new ImageIcon(this.getClass().getResource("/icons/undo.png"))){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RtfDocument.this.undoManager.undo();
                }
                catch (CannotUndoException cannotUndoException) {
                    System.err.println(Messages.getString("rd40") + String.valueOf(cannotUndoException));
                }
                RtfDocument.this.updateUndo();
            }
        };
        JMenuItem jMenuItem10 = jMenu2.add(this.undoAction);
        jMenuItem10.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        jMenu2.add(jMenuItem10);
        this.redoAction = new AbstractAction(Messages.getString("rd41"), new ImageIcon(this.getClass().getResource("/icons/redo.png"))){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RtfDocument.this.undoManager.redo();
                }
                catch (CannotUndoException cannotUndoException) {
                    Log.write(3, this.getClass().getName(), "redoAction", cannotUndoException);
                }
                RtfDocument.this.updateUndo();
            }
        };
        JMenuItem jMenuItem11 = jMenu2.add(this.redoAction);
        jMenuItem11.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        jMenu2.add(jMenuItem11);
        jMenu2.addSeparator();
        AbstractAction abstractAction4 = new AbstractAction(Messages.getString("rd44"), new ImageIcon(this.getClass().getResource("/icons/find-replace.png"))){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RtfDocument.this.repaint();
                if (RtfDocument.this.findDialog == null) {
                    RtfDocument.this.findDialog = new FindDialog(RtfDocument.this.rtfDocument, 0);
                } else {
                    RtfDocument.this.findDialog.setSelectedTab(0);
                }
                Dimension dimension = RtfDocument.this.findDialog.getSize();
                Dimension dimension2 = RtfDocument.this.parentFrame.getSize();
                int n = Math.max((dimension2.width - dimension.width) / 2, 0);
                int n2 = Math.max((dimension2.height - dimension.height) / 2, 0);
                RtfDocument.this.findDialog.setBounds(n + RtfDocument.this.parentFrame.getX(), n2 + RtfDocument.this.parentFrame.getY(), dimension.width, dimension.height);
                RtfDocument.this.findDialog.setVisible(true);
            }
        };
        JMenuItem jMenuItem12 = jMenu2.add(abstractAction4);
        jMenuItem12.setAccelerator(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        AbstractAction abstractAction5 = new AbstractAction(Messages.getString("rd46")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RtfDocument.this.repaint();
                if (RtfDocument.this.findDialog == null) {
                    RtfDocument.this.findDialog = new FindDialog(RtfDocument.this.rtfDocument, 1);
                } else {
                    RtfDocument.this.findDialog.setSelectedTab(1);
                }
                Dimension dimension = RtfDocument.this.findDialog.getSize();
                Dimension dimension2 = RtfDocument.this.parentFrame.getSize();
                int n = Math.max((dimension2.width - dimension.width) / 2, 0);
                int n2 = Math.max((dimension2.height - dimension.height) / 2, 0);
                RtfDocument.this.findDialog.setBounds(n + RtfDocument.this.parentFrame.getX(), n2 + RtfDocument.this.parentFrame.getY(), dimension.width, dimension.height);
                RtfDocument.this.findDialog.setVisible(true);
            }
        };
        JMenuItem jMenuItem13 = jMenu2.add(abstractAction5);
        jMenuItem13.setAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        JMenuItem jMenuItem14 = new JMenuItem(Messages.getString("od5"), new ImageIcon(this.getClass().getResource("/icons/bold_icon.png")));
        jMenu3.add(jMenuItem14);
        jMenuItem14.setAccelerator(KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        jMenuItem14.addActionListener(actionEvent -> {
            this.tbBold.setSelected(!this.tbBold.isSelected());
            this.boldFont();
        });
        jMenuItem14 = new JMenuItem(Messages.getString("od6"), new ImageIcon(this.getClass().getResource("/icons/italic_icon.png")));
        jMenu3.add(jMenuItem14);
        jMenuItem14.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        jMenuItem14.addActionListener(actionEvent -> {
            this.tbItalic.setSelected(!this.tbItalic.isSelected());
            this.italicFont();
        });
        jMenuItem14 = new JMenuItem(Messages.getString("od7"), new ImageIcon(this.getClass().getResource("/icons/underline.png")));
        jMenu3.add(jMenuItem14);
        jMenuItem14.setAccelerator(KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        jMenuItem14.addActionListener(actionEvent -> {
            this.tbUnderline.setSelected(!this.tbUnderline.isSelected());
            this.underlineFont();
        });
        jMenuItem14 = new JMenuItem(Messages.getString("od8"), new ImageIcon(this.getClass().getResource("/icons/strike.png")));
        jMenu3.add(jMenuItem14);
        jMenuItem14.addActionListener(actionEvent -> {
            this.tbStrike.setSelected(!this.tbStrike.isSelected());
            this.strikeFont();
        });
        jMenu3.addSeparator();
        JMenuItem jMenuItem15 = new JMenuItem(Messages.getString("rd55"));
        jMenuItem15.setAccelerator(KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        jMenuItem15.addActionListener(actionEvent -> this.openFontDialog());
        jMenu3.add(jMenuItem15);
        jMenu3.addSeparator();
        jMenuItem14 = new JMenuItem(Messages.getString("od14"));
        jMenu3.add(jMenuItem14);
        jMenuItem14.addActionListener(actionEvent -> this.upperCase());
        jMenuItem14 = new JMenuItem(Messages.getString("od15"));
        jMenu3.add(jMenuItem14);
        jMenuItem14.addActionListener(actionEvent -> {
            this.tbStrike.setSelected(!this.tbStrike.isSelected());
            this.lowerCase();
        });
        this.cmForeground = new ColorMenu(Messages.getString("rd56"));
        this.cmForeground.setColor(this.textArea.getForeground());
        this.cmForeground.addActionListener(actionEvent -> this.colorForeground());
        jMenu4.add(this.cmForeground);
        MenuListener menuListener = new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                MutableAttributeSet mutableAttributeSet = RtfDocument.this.rtfEditorKit.getInputAttributes();
                Color color = StyleConstants.getForeground(mutableAttributeSet);
                if (color != Color.black) {
                    RtfDocument.this.cmForeground.setColor(color);
                }
            }
        };
        this.cmForeground.addMenuListener(menuListener);
        jMenu4.addSeparator();
        JMenuItem jMenuItem16 = new JMenuItem(Messages.getString("rd58"));
        jMenuItem16.setAccelerator(KeyStroke.getKeyStroke(55, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        jMenuItem16.addActionListener(actionEvent -> this.openParagraphDialog());
        jMenu4.add(jMenuItem16);
        jMenu4.addSeparator();
        JMenuItem jMenuItem17 = new JMenuItem(Messages.getString("rd59"));
        jMenuItem17.addActionListener(actionEvent -> this.openImageChooser());
        jMenu4.add(jMenuItem17);
        return jMenuBar;
    }

    JToolBar createBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(true);
        JButton jButton = new JButton("", new ImageIcon(this.getClass().getResource("/icons/action_file.png")));
        jButton.setToolTipText(Messages.getString("rd22"));
        jButton.addActionListener(actionEvent -> this.newDoc());
        jButton.setFocusable(false);
        jToolBar.add(jButton);
        JButton jButton2 = new JButton("", new ImageIcon(this.getClass().getResource("/icons/action_open.png")));
        jButton2.setToolTipText(Messages.getString("rd24"));
        jButton2.addActionListener(actionEvent -> this.openFileChooser());
        jButton2.setFocusable(false);
        jToolBar.add(jButton2);
        JButton jButton3 = new JButton("", new ImageIcon(this.getClass().getResource("/icons/action_save.png")));
        jButton3.setToolTipText(Messages.getString("rd26"));
        jButton3.addActionListener(actionEvent -> this.saveFile());
        jButton3.setFocusable(false);
        jToolBar.add(jButton3);
        JButton jButton4 = new JButton("", new ImageIcon(this.getClass().getResource("/icons/action_saveas.png")));
        jButton4.setToolTipText(Messages.getString("rd28"));
        jButton4.addActionListener(actionEvent -> this.saveFileWithChooser());
        jButton4.setFocusable(false);
        jToolBar.add(jButton4);
        JButton jButton5 = new JButton("", new ImageIcon(this.getClass().getResource("/icons/print.png")));
        jButton5.setToolTipText(Messages.getString("rd30"));
        jButton5.addActionListener(actionEvent -> this.printDocument());
        jButton5.setFocusable(false);
        jToolBar.add(jButton5);
        jToolBar.addSeparator();
        this.cbSizes = new JComboBox<String>(this.fontSizes);
        this.cbSizes.addActionListener(actionEvent -> this.fontSize());
        this.cbSizes.setFocusable(false);
        jToolBar.add(this.cbSizes);
        jToolBar.addSeparator();
        this.cbFonts = new JComboBox<String>(this.fontNames);
        this.cbFonts.setEditable(true);
        this.cbFonts.addActionListener(actionEvent -> this.fontName());
        this.cbFonts.setFocusable(false);
        jToolBar.add(this.cbFonts);
        jToolBar.addSeparator();
        this.tbBold = new JToggleButton(new ImageIcon(this.getClass().getResource("/icons/bold_icon.png")));
        this.tbBold.addActionListener(actionEvent -> this.boldFont());
        this.tbBold.setFocusable(false);
        jToolBar.add(this.tbBold);
        this.tbItalic = new JToggleButton(new ImageIcon(this.getClass().getResource("/icons/italic_icon.png")));
        this.tbItalic.addActionListener(actionEvent -> this.italicFont());
        this.tbItalic.setFocusable(false);
        jToolBar.add(this.tbItalic);
        this.tbUnderline = new JToggleButton(new ImageIcon(this.getClass().getResource("/icons/underline.png")));
        this.tbUnderline.addActionListener(actionEvent -> this.underlineFont());
        this.tbUnderline.setFocusable(false);
        jToolBar.add(this.tbUnderline);
        this.tbStrike = new JToggleButton(new ImageIcon(this.getClass().getResource("/icons/strike.png")));
        this.tbStrike.addActionListener(actionEvent -> this.strikeFont());
        this.tbStrike.setFocusable(false);
        jToolBar.add(this.tbStrike);
        jToolBar.addSeparator();
        this.tbPghLeft = new JToggleButton(new ImageIcon(this.getClass().getResource("/icons/align-left.png")));
        this.tbPghLeft.addActionListener(actionEvent -> this.paragraphLeft());
        this.tbPghLeft.setFocusable(false);
        jToolBar.add(this.tbPghLeft);
        this.tbPghCenter = new JToggleButton(new ImageIcon(this.getClass().getResource("/icons/align-center.png")));
        this.tbPghCenter.addActionListener(actionEvent -> this.paragraphCenter());
        this.tbPghCenter.setFocusable(false);
        jToolBar.add(this.tbPghCenter);
        this.tbPghRight = new JToggleButton(new ImageIcon(this.getClass().getResource("/icons/align-right.png")));
        this.tbPghRight.addActionListener(actionEvent -> this.paragraphRight());
        this.tbPghRight.setFocusable(false);
        jToolBar.add(this.tbPghRight);
        this.tbPghJustify = new JToggleButton(new ImageIcon(this.getClass().getResource("/icons/align-justify.png")));
        this.tbPghJustify.addActionListener(actionEvent -> this.paragraphJustify());
        this.tbPghJustify.setFocusable(false);
        jToolBar.add(this.tbPghJustify);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new Label(" "), "Center");
        jPanel.add((Component)new Label(" "), "East");
        jToolBar.add(jPanel);
        return jToolBar;
    }

    private void updateUndo() {
        if (this.undoManager.canUndo()) {
            this.undoAction.setEnabled(true);
            this.undoAction.putValue("Name", this.undoManager.getUndoPresentationName());
        } else {
            this.undoAction.setEnabled(false);
            this.undoAction.putValue("Name", Messages.getString("rd38"));
        }
        if (this.undoManager.canRedo()) {
            this.redoAction.setEnabled(true);
            this.redoAction.putValue("Name", this.undoManager.getRedoPresentationName());
        } else {
            this.redoAction.setEnabled(false);
            this.redoAction.putValue("Name", Messages.getString("rd41"));
        }
    }

    private void showAttributesOnToolbar() {
        SwingUtilities.invokeLater(() -> {
            int n;
            this.skipUpdate = true;
            MutableAttributeSet mutableAttributeSet = this.rtfEditorKit.getInputAttributes();
            String string = StyleConstants.getFontFamily(mutableAttributeSet);
            if (!this.fontName.equals(string)) {
                this.fontName = string;
                this.cbFonts.setSelectedItem(string);
            }
            if (this.iFontSize != (n = StyleConstants.getFontSize(mutableAttributeSet))) {
                this.iFontSize = n;
                this.cbSizes.setSelectedItem(Integer.toString(this.iFontSize));
            }
            this.tbBold.setSelected(StyleConstants.isBold(mutableAttributeSet));
            this.tbItalic.setSelected(StyleConstants.isItalic(mutableAttributeSet));
            this.tbUnderline.setSelected(StyleConstants.isUnderline(mutableAttributeSet));
            this.tbStrike.setSelected(StyleConstants.isStrikeThrough(mutableAttributeSet));
            int n2 = StyleConstants.getAlignment(mutableAttributeSet);
            if (n2 == 0) {
                this.tbPghLeft.setSelected(true);
            } else {
                this.tbPghLeft.setSelected(false);
            }
            if (n2 == 1) {
                this.tbPghCenter.setSelected(true);
            } else {
                this.tbPghCenter.setSelected(false);
            }
            if (n2 == 2) {
                this.tbPghRight.setSelected(true);
            } else {
                this.tbPghRight.setSelected(false);
            }
            if (n2 == 3) {
                this.tbPghJustify.setSelected(true);
            } else {
                this.tbPghJustify.setSelected(false);
            }
            this.skipUpdate = false;
        });
    }

    private void setAttributeSet(AttributeSet attributeSet, boolean bl) {
        if (this.skipUpdate) {
            return;
        }
        int n = this.textArea.getSelectionStart();
        int n2 = this.textArea.getSelectionEnd();
        if (!this.textArea.hasFocus()) {
            n = this.ixStart;
            n2 = this.ixFinish;
        }
        if (bl) {
            this.document.setParagraphAttributes(n, n2 - n, attributeSet, false);
        } else if (n != n2) {
            this.document.setCharacterAttributes(n, n2 - n, attributeSet, false);
        } else {
            MutableAttributeSet mutableAttributeSet = this.rtfEditorKit.getInputAttributes();
            mutableAttributeSet.addAttributes(attributeSet);
        }
        this.showAttributesOnToolbar();
    }

    public StyledDocument getDocument() {
        return this.document;
    }

    public JTextPane getTextPane() {
        return this.textArea;
    }

    public void setSelection(int n, int n2, boolean bl) {
        if (bl) {
            this.textArea.setCaretPosition(n2);
            this.textArea.moveCaretPosition(n);
        } else {
            this.textArea.select(n, n2);
        }
        this.ixStart = this.textArea.getSelectionStart();
        this.ixFinish = this.textArea.getSelectionEnd();
    }

    private void fontName() {
        this.fontName = Objects.requireNonNull(this.cbFonts.getSelectedItem()).toString();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setFontFamily(simpleAttributeSet, this.fontName);
        this.setAttributeSet(simpleAttributeSet, false);
    }

    private void boldFont() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setBold(simpleAttributeSet, this.tbBold.isSelected());
        this.setAttributeSet(simpleAttributeSet, false);
    }

    private void italicFont() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setItalic(simpleAttributeSet, this.tbItalic.isSelected());
        this.setAttributeSet(simpleAttributeSet, false);
    }

    private void underlineFont() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setUnderline(simpleAttributeSet, this.tbUnderline.isSelected());
        this.setAttributeSet(simpleAttributeSet, false);
    }

    private void strikeFont() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setStrikeThrough(simpleAttributeSet, this.tbStrike.isSelected());
        this.setAttributeSet(simpleAttributeSet, false);
    }

    private void upperCase() {
        String string = this.textArea.getSelectedText();
        if (string != null && string.length() > 0) {
            string = string.toUpperCase();
            this.textArea.replaceSelection(string);
        }
    }

    private void lowerCase() {
        String string = this.textArea.getSelectedText();
        if (string != null && string.length() > 0) {
            string = string.toLowerCase();
            this.textArea.replaceSelection(string);
        }
    }

    private void colorForeground() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, this.cmForeground.getColor());
        this.setAttributeSet(simpleAttributeSet, false);
    }

    private void openFileChooser() {
        try {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new RtfFileFilter());
            jFileChooser.setCurrentDirectory(new File(this.chooserFilePath));
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.openRtfFile(file);
            }
        }
        catch (Exception exception) {
            Log.write(3, this.getClass().getName(), "openFileChooser", exception);
        }
    }

    public void openRtfFile(File file) {
        if (file.exists()) {
            if (!file.canRead()) {
                try {
                    Thread.sleep(217L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!file.canRead()) {
                JOptionPane.showInternalMessageDialog(this.getParent(), "File blocked, read file '" + file.getName() + "' not possible", "jRep", 2);
            } else {
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    this.textArea.setText("");
                    this.rtfEditorKit.read(fileInputStream, (Document)this.document, 0);
                    this.document.remove(this.document.getLength() - 1, 1);
                    this.chooserFilePath = file.getParent();
                    this.chooserFile = file;
                    this.parentFrame.setTitle(file.getName());
                    this.checkForDuration(true);
                    this.undoManager.discardAllEdits();
                    this.updateUndo();
                }
                catch (Exception exception) {
                    JOptionPane.showInternalMessageDialog(this.getParent(), "Exception while read file: " + exception.getClass().getName() + ", " + exception.getMessage(), "jRep", 2);
                    Log.write(3, this.getClass().getName(), "openRtfFile", exception);
                }
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.repaint();
        this.textArea.grabFocus();
    }

    private void openImageChooser() {
        block5: {
            try {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setCurrentDirectory(new File(this.chooserFilePath));
                int n = jFileChooser.showOpenDialog(this);
                if (n != 0) break block5;
                File file = jFileChooser.getSelectedFile();
                this.repaint();
                try {
                    ImageIcon imageIcon = new ImageIcon(file.getPath());
                    int n2 = imageIcon.getIconWidth();
                    int n3 = imageIcon.getIconHeight();
                    if (n2 <= 0 || n3 <= 0) {
                        JOptionPane.showMessageDialog(this, Messages.getString("rd87") + file.getPath(), Messages.getString("d4"), 2);
                        return;
                    }
                    SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                    StyleConstants.setIcon(simpleAttributeSet, imageIcon);
                    int n4 = this.textArea.getCaretPosition();
                    this.document.insertString(n4, " ", simpleAttributeSet);
                }
                catch (Exception exception) {
                    Log.write(3, this.getClass().getName(), "openImageChooser-choose", exception);
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            catch (Exception exception) {
                Log.write(3, this.getClass().getName(), "openImageChooser", exception);
            }
        }
    }

    private int saveWithCheck() {
        if (this.undoManager.canUndo()) {
            int n;
            Object object = "?";
            if (this.chooserFile != null && this.chooserFile.exists()) {
                object = " [" + this.chooserFile.getName() + "] ?";
            }
            if ((n = JOptionPane.showConfirmDialog(null, Messages.getString("rd90") + (String)object)) == 0) {
                if (this.chooserFile != null && this.chooserFile.exists()) {
                    this.saveChooserFile();
                } else {
                    this.saveFileWithChooser();
                }
            }
            return n;
        }
        return 0;
    }

    private void saveFile() {
        if (this.chooserFile != null && this.chooserFile.exists()) {
            this.saveChooserFile();
        } else {
            this.saveFileWithChooser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveChooserFile() {
        if (this.chooserFile.exists() && !this.chooserFile.canWrite()) {
            try {
                Thread.sleep(237L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object object = this.saveLock;
        synchronized (object) {
            if (this.chooserFile.exists() && !this.chooserFile.canWrite()) {
                JOptionPane.showInternalMessageDialog(this.getParent(), "File blocked, save file '" + this.chooserFile.getName() + "' not possible", "jRep", 2);
            } else {
                try (FileOutputStream fileOutputStream = new FileOutputStream(this.chooserFile, false);){
                    this.checkForDuration(false);
                    this.rtfEditorKit.write(fileOutputStream, (Document)this.document, 0, this.document.getLength());
                    this.parentFrame.setTitle(this.chooserFile.getName());
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    this.undoManager.discardAllEdits();
                    this.updateUndo();
                }
                catch (Exception exception) {
                    JOptionPane.showInternalMessageDialog(this.getParent(), "Exception while saving file: " + exception.getClass().getName() + ", " + exception.getMessage(), "jRep", 2);
                    Log.write(3, this.getClass().getName(), "saveChooserFile", exception);
                }
            }
        }
    }

    private void saveFileWithChooser() {
        try {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new RtfFileFilter());
            jFileChooser.setCurrentDirectory(new File(this.chooserFilePath));
            int n = jFileChooser.showSaveDialog(this);
            this.repaint();
            if (n == 0) {
                int n2;
                File file = jFileChooser.getSelectedFile();
                String string = file.getAbsolutePath();
                if (!string.toLowerCase().endsWith(".rtf")) {
                    file = new File(string + ".rtf");
                }
                if (file.exists() && (n2 = JOptionPane.showConfirmDialog(null, Messages.getString("rd93"), Messages.getString("rd94"), 0, 3)) != 0) {
                    return;
                }
                this.chooserFilePath = file.getParent();
                this.chooserFile = file;
                this.saveChooserFile();
            }
        }
        catch (Exception exception) {
            Log.write(3, this.getClass().getName(), "saveFileWithChooser", exception);
        }
    }

    private void printDocument() {
        try {
            this.checkForDuration(false);
            boolean bl = this.textArea.print();
            if (bl) {
                JOptionPane.showMessageDialog(null, Messages.getString("rd95"));
            }
        }
        catch (Exception exception) {
            Log.write(3, this.getClass().getName(), "printDocument", exception);
        }
    }

    private void exitAction() {
        this.closeEditor(this.saveWithCheck());
    }

    private void newDoc() {
        try {
            int n = this.saveWithCheck();
            if (n == 0 || n == 1) {
                this.textArea.setText("");
                this.undoManager.discardAllEdits();
                this.updateUndo();
                this.parentFrame.setTitle(Messages.getString("rd22"));
                this.showAttributesOnToolbar();
            }
        }
        catch (Exception exception) {
            Log.write(3, this.getClass().getName(), "newDoc", exception);
        }
    }

    private void fontSize() {
        int n = 0;
        try {
            n = Integer.parseInt(Objects.requireNonNull(this.cbSizes.getSelectedItem()).toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.iFontSize = n;
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setFontSize(simpleAttributeSet, n);
        this.setAttributeSet(simpleAttributeSet, false);
    }

    private void openFontDialog() {
        this.repaint();
        MutableAttributeSet mutableAttributeSet = this.rtfEditorKit.getInputAttributes();
        this.fontDialog.setAttributes(mutableAttributeSet);
        Dimension dimension = this.fontDialog.getSize();
        Dimension dimension2 = this.parentFrame.getSize();
        int n = Math.max((dimension2.width - dimension.width) / 2, 0);
        int n2 = Math.max((dimension2.height - dimension.height) / 2, 0);
        this.fontDialog.setBounds(n + this.parentFrame.getX(), n2 + this.parentFrame.getY(), dimension.width, dimension.height);
        this.fontDialog.setVisible(true);
        if (this.fontDialog.getOption() == 0) {
            this.setAttributeSet(this.fontDialog.getAttributes(), false);
        }
    }

    private void openParagraphDialog() {
        this.repaint();
        MutableAttributeSet mutableAttributeSet = this.rtfEditorKit.getInputAttributes();
        this.paragraphDialog.setAttributesph(mutableAttributeSet);
        Dimension dimension = this.paragraphDialog.getSize();
        Dimension dimension2 = this.parentFrame.getSize();
        int n = Math.max((dimension2.width - dimension.width) / 2, 0);
        int n2 = Math.max((dimension2.height - dimension.height) / 2, 0);
        this.paragraphDialog.setBounds(n + this.parentFrame.getX(), n2 + this.parentFrame.getY(), dimension.width, dimension.height);
        this.paragraphDialog.setVisible(true);
        if (this.paragraphDialog.getOption() == 0) {
            this.setAttributeSet(this.paragraphDialog.getAttributesph(), true);
        }
    }

    private void paragraphLeft() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        this.setAttributeSet(simpleAttributeSet, true);
    }

    private void paragraphCenter() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 1);
        this.setAttributeSet(simpleAttributeSet, true);
    }

    private void paragraphRight() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 2);
        this.setAttributeSet(simpleAttributeSet, true);
    }

    private void paragraphJustify() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 3);
        this.setAttributeSet(simpleAttributeSet, true);
    }

    WindowListener getWindowCloser() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                try {
                    RtfDocument.this.closeEditor(RtfDocument.this.saveWithCheck());
                }
                catch (Exception exception) {
                    Log.write(3, this.getClass().getName(), "getWindowCloser", exception);
                }
            }
        };
    }

    public void closeFromJRep() {
        this.saveWithCheck();
        this.closeEditor(0);
    }

    private void closeEditor(int n) {
        try {
            if (n == 0 || n == 1) {
                Thread.sleep(91L);
                this.parentFrame.dispose();
            }
        }
        catch (Exception exception) {
            Log.write(3, this.getClass().getName(), "closeEditor", exception);
        }
    }

    private void checkForDuration(boolean bl) {
        int n;
        if (bl) {
            this.durationString = "[DURATION]";
            this.durationStart = new Date();
        }
        String string = null;
        try {
            string = this.document.getText(0, this.document.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (string != null && (n = string.indexOf(this.durationString)) > 0) {
            int n2 = this.textArea.getCaretPosition();
            int n3 = this.durationString.length();
            this.textArea.select(n, n + n3);
            long l = ((new Date().getTime() - this.durationStart.getTime()) / 1000L + 30L) / 60L;
            String string2 = "[" + l + " " + Messages.getString("rt1") + "]";
            this.textArea.replaceSelection(string2);
            this.durationString = string2;
            if (n2 > n) {
                n2 = n2 - n3 + this.durationString.length();
            }
            this.textArea.setCaretPosition(n2);
        }
    }

    private class Undoer
    implements UndoableEditListener {
        Undoer() {
            RtfDocument.this.undoManager.die();
            RtfDocument.this.updateUndo();
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            RtfDocument.this.undoManager.addEdit(undoableEditEvent.getEdit());
            RtfDocument.this.updateUndo();
        }
    }
}

