/*
 * Decompiled with CFR 0.152.
 */
package com.rtfui;

import ch.steph.util.Log;
import com.rtfui.RtfDocument;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;

public class RtfUI
extends JFrame {
    private final RtfDocument rtfDocument = new RtfDocument();

    public RtfUI(Rectangle rectangle) throws HeadlessException {
        super("RtfUI");
        this.getContentPane().add(this.rtfDocument);
        JToolBar jToolBar = this.rtfDocument.createBar();
        this.getContentPane().add((Component)jToolBar, "North");
        JMenuBar jMenuBar = this.rtfDocument.createMenu();
        this.setJMenuBar(jMenuBar);
        this.rtfDocument.initialize(this);
        this.setIconImage(this.getImageIcon().getImage());
        this.pack();
        if (rectangle == null) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            rectangle = new Rectangle();
            rectangle.x = dimension.width / 8;
            rectangle.y = dimension.height / 16;
            rectangle.width = dimension.width * 3 / 4;
            rectangle.height = dimension.height * 7 / 8;
        }
        this.setBounds(rectangle);
        this.setVisible(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.rtfDocument.getWindowCloser());
    }

    private ImageIcon getImageIcon() {
        try {
            URL uRL = ClassLoader.getSystemResource("icons/align-center.png");
            if (uRL != null) {
                Image image = Toolkit.getDefaultToolkit().getImage(uRL);
                MediaTracker mediaTracker = new MediaTracker(this);
                mediaTracker.addImage(image, 0);
                mediaTracker.waitForAll();
                return new ImageIcon(image);
            }
        }
        catch (Exception exception) {
            Log.write(3, this.getClass().getName(), "getImageIcon", exception);
        }
        return null;
    }

    public void openRtfFile(File file) {
        this.rtfDocument.openRtfFile(file);
    }

    public void closeFromJRep() {
        this.rtfDocument.closeFromJRep();
    }
}

