/*
 * Decompiled with CFR 0.152.
 */
package com.rtfui.dialog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.MenuSelectionManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public class ColorMenu
extends JMenu {
    private static final long serialVersionUID = 1L;
    private final Border activeBorder;
    private final Map<Color, ColorPane> colorPanes;
    private final Border selectedBorder;
    private ColorPane selectedColorPane;
    private final Border unselectedBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, this.getBackground()), new BevelBorder(1, Color.WHITE, Color.GRAY));

    public ColorMenu(String string) {
        super(string);
        int[] nArray;
        this.selectedBorder = new CompoundBorder(new MatteBorder(2, 2, 2, 2, Color.RED), new MatteBorder(1, 1, 1, 1, this.getBackground()));
        this.activeBorder = new CompoundBorder(new MatteBorder(2, 2, 2, 2, Color.BLUE), new MatteBorder(1, 1, 1, 1, this.getBackground()));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new GridLayout(8, 8));
        this.colorPanes = new HashMap<Color, ColorPane>();
        for (int n : nArray = new int[]{0, 128, 192, 255}) {
            for (int n2 : nArray) {
                for (int n3 : nArray) {
                    Color color = new Color(n, n2, n3);
                    ColorPane colorPane = new ColorPane(color);
                    jPanel.add(colorPane);
                    this.colorPanes.put(color, colorPane);
                }
            }
        }
        this.add(jPanel);
    }

    public void setColor(Color color) {
        ColorPane colorPane = this.colorPanes.get(color);
        if (colorPane == null) {
            return;
        }
        if (this.selectedColorPane != null) {
            this.selectedColorPane.setSelected(false);
        }
        this.selectedColorPane = colorPane;
        this.selectedColorPane.setSelected(true);
    }

    public Color getColor() {
        if (this.selectedColorPane == null) {
            return null;
        }
        return this.selectedColorPane.getColor();
    }

    private void doSelection() {
        this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
    }

    class ColorPane
    extends JPanel
    implements MouseListener {
        private static final long serialVersionUID = -1234630827742960572L;
        final Color color;
        boolean isSelected;

        ColorPane(Color color) {
            this.color = color;
            this.setBackground(color);
            this.setBorder(ColorMenu.this.unselectedBorder);
            String string = "rgb( " + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + " )";
            this.setToolTipText(string);
            this.addMouseListener(this);
        }

        void setSelected(boolean bl) {
            this.isSelected = bl;
            if (bl) {
                this.setBorder(ColorMenu.this.selectedBorder);
            } else {
                this.setBorder(ColorMenu.this.unselectedBorder);
            }
        }

        Color getColor() {
            return this.color;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(15, 15);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.setBorder(ColorMenu.this.activeBorder);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.setBorder(this.isSelected ? ColorMenu.this.selectedBorder : ColorMenu.this.unselectedBorder);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            ColorMenu.this.setColor(this.color);
            MenuSelectionManager.defaultManager().clearSelectedPath();
            ColorMenu.this.doSelection();
        }
    }
}

