/*
 * Decompiled with CFR 0.152.
 */
package com.rtfui.dialog;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

class DialogLayout
implements LayoutManager {
    private int divider = -1;
    private int hGap;
    private int vGap;

    public DialogLayout(int n, int n2) {
        this.hGap = n;
        this.vGap = n2;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        int n = this.getDivider(container);
        int n2 = 0;
        int n3 = 0;
        for (int i = 1; i < container.getComponentCount(); i += 2) {
            Component component = container.getComponent(i);
            Dimension dimension = component.getPreferredSize();
            n2 = Math.max(n2, dimension.width);
            n3 += dimension.height + this.vGap;
        }
        Insets insets = container.getInsets();
        return new Dimension(n + n2 + insets.left + insets.right, (n3 -= this.vGap) + insets.top + insets.bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public void layoutContainer(Container container) {
        int n = this.getDivider(container);
        Insets insets = container.getInsets();
        int n2 = container.getWidth() - insets.left - insets.right - n;
        int n3 = insets.left;
        int n4 = insets.top;
        for (int i = 1; i < container.getComponentCount(); i += 2) {
            Component component = container.getComponent(i - 1);
            Component component2 = container.getComponent(i);
            Dimension dimension = component2.getPreferredSize();
            component.setBounds(n3, n4, n, dimension.height);
            component2.setBounds(n3 + n, n4, n2, dimension.height);
            n4 += dimension.height + this.vGap;
        }
    }

    private int getDivider(Container container) {
        if (this.divider > 0) {
            return this.divider;
        }
        this.divider = 0;
        for (int i = 0; i < container.getComponentCount(); i += 2) {
            Component component = container.getComponent(i);
            Dimension dimension = component.getPreferredSize();
            this.divider = Math.max(this.divider, dimension.width);
        }
        this.divider += this.hGap;
        return this.divider;
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hGap + ",vgap=" + this.vGap + ",divider=" + this.divider + "]";
    }
}

