/*
 * Decompiled with CFR 0.152.
 */
package com.rtfui.dialog;

import com.rtfui.Messages;
import com.rtfui.RtfDocument;
import com.rtfui.dialog.DialogLayout;
import com.rtfui.help.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;

public class FindDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final RtfDocument owner;
    private final JTabbedPane tb;
    private final JTextField txtFind1;
    private JTextField txtFind2;
    private final JTextField txtReplace;
    private final ButtonModel cbWord;
    private final ButtonModel cbCase;
    private final ButtonModel cbSearchUp;
    private int searchIndex = -1;
    private boolean searchUp = false;
    private String searchedString;

    public FindDialog(RtfDocument rtfDocument, int n) {
        this.setModal(true);
        this.owner = rtfDocument;
        this.tb = new JTabbedPane();
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new DialogLayout(20, 5));
        jPanel3.setBorder(new EmptyBorder(8, 5, 8, 0));
        jPanel3.add(new JLabel(Messages.getString("fd0")));
        this.txtFind1 = new JTextField();
        jPanel3.add(this.txtFind1);
        jPanel2.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel(new GridLayout(2, 2, 8, 2));
        jPanel4.setBorder(new TitledBorder(new EtchedBorder(), Messages.getString("fd1")));
        JCheckBox jCheckBox = new JCheckBox(Messages.getString("fd2"));
        jCheckBox.setMnemonic('w');
        this.cbWord = jCheckBox.getModel();
        jPanel4.add(jCheckBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton(Messages.getString("fd3"));
        jRadioButton.setMnemonic('u');
        this.cbSearchUp = jRadioButton.getModel();
        buttonGroup.add(jRadioButton);
        jPanel4.add(jRadioButton);
        JCheckBox jCheckBox2 = new JCheckBox(Messages.getString("fd4"));
        jCheckBox2.setMnemonic('c');
        this.cbCase = jCheckBox2.getModel();
        jPanel4.add(jCheckBox2);
        JRadioButton jRadioButton2 = new JRadioButton(Messages.getString("fd5"), true);
        jRadioButton2.setMnemonic('d');
        ButtonModel buttonModel = jRadioButton2.getModel();
        buttonGroup.add(jRadioButton2);
        jPanel4.add(jRadioButton2);
        jPanel2.add((Component)jPanel4, "South");
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel5 = new JPanel(new FlowLayout());
        JPanel jPanel6 = new JPanel(new GridLayout(2, 1, 2, 8));
        JButton jButton = new JButton(Messages.getString("fd6"));
        jButton.setMnemonic('f');
        jPanel6.add(jButton);
        jButton.addActionListener(actionEvent -> {
            this.txtFind2.setText(this.txtFind1.getText());
            this.findNext(true);
        });
        JButton jButton2 = new JButton(Messages.getString("d0"));
        jButton2.addActionListener(actionEvent -> this.closeAction());
        jButton2.setDefaultCapable(true);
        jPanel6.add(jButton2);
        jPanel5.add(jPanel6);
        jPanel.add((Component)jPanel5, "East");
        this.tb.addTab(Messages.getString("fd8"), jPanel);
        JPanel jPanel7 = new JPanel(new BorderLayout());
        JPanel jPanel8 = new JPanel(new BorderLayout());
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new DialogLayout(20, 5));
        jPanel9.setBorder(new EmptyBorder(8, 5, 8, 0));
        jPanel9.add(new JLabel(Messages.getString("fd0")));
        this.txtFind2 = new JTextField();
        jPanel9.add(this.txtFind2);
        jPanel9.add(new JLabel(Messages.getString("fd10")));
        this.txtReplace = new JTextField();
        jPanel9.add(this.txtReplace);
        jPanel8.add((Component)jPanel9, "Center");
        jPanel4 = new JPanel(new GridLayout(2, 2, 8, 2));
        jPanel4.setBorder(new TitledBorder(new EtchedBorder(), Messages.getString("fd1")));
        jCheckBox = new JCheckBox(Messages.getString("fd2"));
        jCheckBox.setMnemonic('w');
        jCheckBox.setModel(this.cbWord);
        jPanel4.add(jCheckBox);
        buttonGroup = new ButtonGroup();
        jRadioButton = new JRadioButton(Messages.getString("fd3"));
        jRadioButton.setMnemonic('u');
        jRadioButton.setModel(this.cbSearchUp);
        buttonGroup.add(jRadioButton);
        jPanel4.add(jRadioButton);
        jCheckBox2 = new JCheckBox(Messages.getString("fd4"));
        jCheckBox2.setMnemonic('c');
        jCheckBox2.setModel(this.cbCase);
        jPanel4.add(jCheckBox2);
        jRadioButton2 = new JRadioButton(Messages.getString("fd5"), true);
        jRadioButton2.setMnemonic('d');
        jRadioButton2.setModel(buttonModel);
        buttonGroup.add(jRadioButton2);
        jPanel4.add(jRadioButton2);
        jPanel8.add((Component)jPanel4, "South");
        jPanel7.add((Component)jPanel8, "Center");
        JPanel jPanel10 = new JPanel(new FlowLayout());
        jPanel6 = new JPanel(new GridLayout(3, 1, 2, 8));
        JButton jButton3 = new JButton(Messages.getString("fd16"));
        jButton3.setMnemonic('r');
        jPanel6.add(jButton3);
        jButton3.addActionListener(actionEvent -> {
            this.txtFind1.setText(this.txtFind2.getText());
            this.replaceSelection();
            this.findNext(true);
        });
        JButton jButton4 = new JButton(Messages.getString("fd17"));
        jButton4.addActionListener(actionEvent -> {
            this.txtFind1.setText(this.txtFind2.getText());
            this.replaceAllAction();
        });
        jButton4.setMnemonic('a');
        jPanel6.add(jButton4);
        jButton2 = new JButton(Messages.getString("d0"));
        jButton2.addActionListener(actionEvent -> this.closeAction());
        jButton2.setDefaultCapable(true);
        jPanel6.add(jButton2);
        jPanel10.add(jPanel6);
        jPanel7.add((Component)jPanel10, "East");
        jPanel5.setPreferredSize(jPanel10.getPreferredSize());
        this.tb.addTab(Messages.getString("fd16"), jPanel7);
        this.tb.setSelectedIndex(n);
        this.getContentPane().add((Component)this.tb, "Center");
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                FindDialog.this.searchIndex = -1;
                if (FindDialog.this.tb.getSelectedIndex() == 0) {
                    FindDialog.this.txtFind1.grabFocus();
                } else {
                    FindDialog.this.txtFind2.grabFocus();
                }
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                FindDialog.this.searchedString = null;
            }
        };
        this.addWindowListener(windowAdapter);
        this.pack();
        this.setResizable(false);
    }

    public void setSelectedTab(int n) {
        this.tb.setSelectedIndex(n);
        this.setVisible(true);
        this.searchIndex = -1;
    }

    private int findNext(boolean bl) {
        int n;
        int n2;
        block15: {
            Object object;
            JTextPane jTextPane = this.owner.getTextPane();
            int n3 = jTextPane.getCaretPosition();
            if (this.cbSearchUp.isSelected() != this.searchUp) {
                this.searchUp = this.cbSearchUp.isSelected();
                this.searchIndex = -1;
            }
            if (this.searchIndex == -1) {
                try {
                    object = this.owner.getDocument();
                    this.searchedString = this.searchUp ? object.getText(0, n3) : object.getText(n3, object.getLength() - n3);
                    this.searchIndex = n3;
                    if (!this.cbCase.isSelected()) {
                        this.searchedString = this.searchedString.toLowerCase();
                    }
                }
                catch (BadLocationException badLocationException) {
                    this.warning(badLocationException.toString());
                    return -1;
                }
            }
            if (((String)(object = this.txtFind1.getText())).length() == 0) {
                this.warning(Messages.getString("fd20"));
                return -1;
            }
            if (!this.cbCase.isSelected()) {
                object = ((String)object).toLowerCase();
            }
            if (this.cbWord.isSelected()) {
                for (char c : Utils.WORD_SEPARATORS) {
                    if (((String)object).indexOf(c) < 0) continue;
                    this.warning("The text target contains an illegal character '" + c + "'");
                    return -1;
                }
            }
            while (true) {
                boolean bl2;
                char c;
                if ((n2 = this.searchUp ? this.searchedString.lastIndexOf((String)object, n3 - 1) : this.searchedString.indexOf((String)object, n3 - this.searchIndex)) < 0) {
                    if (bl) {
                        this.warning(Messages.getString("fd24"));
                    }
                    return 0;
                }
                n = n2 + ((String)object).length();
                if (!this.cbWord.isSelected()) break block15;
                int n4 = n2 > 0 ? 1 : 0;
                c = n4 != 0 && !Utils.isSeparator(this.searchedString.charAt(n2 - 1)) ? (char)'\u0001' : '\u0000';
                boolean bl3 = n < this.searchedString.length();
                boolean bl4 = bl2 = bl3 && !Utils.isSeparator(this.searchedString.charAt(n));
                if (c == '\u0000' && !bl2) break block15;
                if (this.searchUp && n4 != 0) {
                    n3 = n2;
                    continue;
                }
                if (this.searchUp || !bl3) break;
                n3 = n;
            }
            if (bl) {
                this.warning(Messages.getString("fd24"));
            }
            return 0;
        }
        if (!this.searchUp) {
            n2 += this.searchIndex;
            n += this.searchIndex;
        }
        this.owner.setSelection(n2, n, this.searchUp);
        return 1;
    }

    private boolean replaceSelection() {
        String string = this.owner.getTextPane().getSelectedText();
        String string2 = this.txtFind2.getText();
        if (string != null && string.length() > 0 && string.equalsIgnoreCase(string2)) {
            this.owner.getTextPane().replaceSelection(this.txtReplace.getText());
            return true;
        }
        return false;
    }

    private void warning(String string) {
        JOptionPane.showMessageDialog(this.owner, string, Messages.getString("d4"), 1);
    }

    private void closeAction() {
        this.setVisible(false);
    }

    private void replaceAllAction() {
        int n;
        int n2 = 0;
        this.owner.getTextPane().setCaretPosition(0);
        do {
            this.searchIndex = -1;
            if (this.replaceSelection()) {
                ++n2;
            }
            if ((n = this.findNext(false)) >= 0) continue;
            return;
        } while (n != 0);
        JOptionPane.showMessageDialog(this.owner, n2 + Messages.getString("fd27"), Messages.getString("d5"), 1);
    }
}

