/*
 * Decompiled with CFR 0.152.
 */
package com.rtfui.dialog;

import com.rtfui.Messages;
import com.rtfui.dialog.ColorComboRender;
import com.rtfui.dialog.OpenList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.lang.constant.Constable;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class FontDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private int returnOption = -1;
    private final OpenList lstFontName;
    private final OpenList lstFontSize;
    private MutableAttributeSet attributes;
    private final JCheckBox chkBold;
    private final JCheckBox chkItalic;
    private final JCheckBox chkUnderline;
    private final JCheckBox chkStrikethrough;
    private final JCheckBox chkSubscript;
    private final JCheckBox chkSuperscript;
    private final JComboBox<Color> cbColor;
    private final JLabel preview;

    public FontDialog(JFrame jFrame, String[] stringArray, String[] stringArray2) {
        super(jFrame, Messages.getString("od0"), true);
        this.setModal(true);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 10, 2));
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), ""));
        this.lstFontName = new OpenList(stringArray, Messages.getString("od2"));
        jPanel.add(this.lstFontName);
        this.lstFontSize = new OpenList(stringArray2, Messages.getString("od3"));
        jPanel.add(this.lstFontSize);
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new GridLayout(2, 3, 10, 5));
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), Messages.getString("od4")));
        this.chkBold = new JCheckBox(Messages.getString("od5"));
        jPanel.add(this.chkBold);
        this.chkItalic = new JCheckBox(Messages.getString("od6"));
        jPanel.add(this.chkItalic);
        this.chkUnderline = new JCheckBox(Messages.getString("od7"));
        jPanel.add(this.chkUnderline);
        this.chkStrikethrough = new JCheckBox(Messages.getString("od8"));
        jPanel.add(this.chkStrikethrough);
        this.chkSubscript = new JCheckBox(Messages.getString("od9"));
        jPanel.add(this.chkSubscript);
        this.chkSuperscript = new JCheckBox(Messages.getString("od10"));
        jPanel.add(this.chkSuperscript);
        this.getContentPane().add(jPanel);
        this.getContentPane().add(Box.createVerticalStrut(5));
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(new JLabel(Messages.getString("od11")));
        jPanel.add(Box.createHorizontalStrut(20));
        this.cbColor = new JComboBox();
        int[] nArray = new int[]{0, 128, 192, 255};
        for (int n : nArray) {
            for (int listSelectionListener : nArray) {
                for (int n2 : nArray) {
                    Color color = new Color(n, listSelectionListener, n2);
                    this.cbColor.addItem(color);
                }
            }
        }
        this.cbColor.setRenderer(new ColorComboRender());
        jPanel.add(this.cbColor);
        jPanel.add(Box.createHorizontalStrut(10));
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), Messages.getString("d3")));
        this.preview = new JLabel(Messages.getString("od13"), 0);
        this.preview.setBackground(Color.white);
        this.preview.setForeground(Color.black);
        this.preview.setOpaque(true);
        this.preview.setBorder(new LineBorder(Color.black));
        this.preview.setPreferredSize(new Dimension(120, 40));
        jPanel.add((Component)this.preview, "Center");
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new FlowLayout());
        Object object = new JPanel(new GridLayout(1, 2, 10, 2));
        JButton jButton = new JButton(Messages.getString("d1"));
        jButton.addActionListener(actionEvent -> this.confirm());
        ((Container)object).add(jButton);
        JButton jButton2 = new JButton(Messages.getString("d2"));
        jButton2.addActionListener(actionEvent -> this.cancel());
        ((Container)object).add(jButton2);
        jPanel.add((Component)object);
        this.getContentPane().add(jPanel);
        this.pack();
        this.setResizable(false);
        Dimension dimension = this.getSize();
        Dimension dimension2 = jFrame.getSize();
        int n = Math.max((dimension2.width - dimension.width) / 2, 0);
        int n3 = Math.max((dimension2.height - dimension.height) / 2, 0);
        this.setBounds(n, n3, dimension.width, dimension.height);
        ListSelectionListener listSelectionListener = listSelectionEvent -> this.updatePreview();
        this.lstFontName.addListSelectionListener(listSelectionListener);
        this.lstFontSize.addListSelectionListener(listSelectionListener);
        ActionListener actionListener = actionEvent -> this.updatePreview();
        this.chkBold.addActionListener(actionListener);
        this.chkItalic.addActionListener(actionListener);
        this.chkUnderline.addActionListener(actionListener);
        this.chkStrikethrough.addActionListener(actionListener);
        this.chkSubscript.addActionListener(actionListener);
        this.chkSuperscript.addActionListener(actionListener);
        this.cbColor.addActionListener(actionListener);
    }

    public void setAttributes(AttributeSet attributeSet) {
        this.attributes = new SimpleAttributeSet(attributeSet);
        String string = StyleConstants.getFontFamily(attributeSet);
        this.lstFontName.setSelected(string);
        int n = StyleConstants.getFontSize(attributeSet);
        this.lstFontSize.setSelectedInt(n);
        this.chkBold.setSelected(StyleConstants.isBold(attributeSet));
        this.chkItalic.setSelected(StyleConstants.isItalic(attributeSet));
        this.chkUnderline.setSelected(StyleConstants.isUnderline(attributeSet));
        this.chkStrikethrough.setSelected(StyleConstants.isStrikeThrough(attributeSet));
        this.chkSubscript.setSelected(StyleConstants.isSubscript(attributeSet));
        this.chkSuperscript.setSelected(StyleConstants.isSuperscript(attributeSet));
        this.cbColor.setSelectedItem(StyleConstants.getForeground(attributeSet));
        this.updatePreview();
    }

    public AttributeSet getAttributes() {
        if (this.attributes == null) {
            return null;
        }
        StyleConstants.setFontFamily(this.attributes, this.lstFontName.getSelected());
        StyleConstants.setFontSize(this.attributes, this.lstFontSize.getSelectedInt());
        StyleConstants.setBold(this.attributes, this.chkBold.isSelected());
        StyleConstants.setItalic(this.attributes, this.chkItalic.isSelected());
        StyleConstants.setUnderline(this.attributes, this.chkUnderline.isSelected());
        StyleConstants.setStrikeThrough(this.attributes, this.chkStrikethrough.isSelected());
        StyleConstants.setSubscript(this.attributes, this.chkSubscript.isSelected());
        StyleConstants.setSuperscript(this.attributes, this.chkSuperscript.isSelected());
        StyleConstants.setForeground(this.attributes, (Color)this.cbColor.getSelectedItem());
        return this.attributes;
    }

    public int getOption() {
        return this.returnOption;
    }

    private void updatePreview() {
        String string = this.lstFontName.getSelected();
        int n = this.lstFontSize.getSelectedInt();
        if (n <= 0) {
            return;
        }
        int n2 = 0;
        if (this.chkBold.isSelected()) {
            n2 |= 1;
        }
        if (this.chkItalic.isSelected()) {
            n2 |= 2;
        }
        Font font = new Font(string, n2, n);
        HashMap<TextAttribute, Constable> hashMap = new HashMap<TextAttribute, Constable>();
        if (this.chkUnderline.isSelected()) {
            hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (this.chkStrikethrough.isSelected()) {
            hashMap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        if (this.chkSuperscript.isSelected()) {
            hashMap.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
        }
        if (this.chkSubscript.isSelected()) {
            hashMap.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
        }
        if (hashMap.size() > 0) {
            font = font.deriveFont(hashMap);
        }
        this.preview.setFont(font);
        Color color = (Color)this.cbColor.getSelectedItem();
        this.preview.setForeground(color);
        this.preview.repaint();
    }

    private void confirm() {
        this.returnOption = 0;
        this.setVisible(false);
    }

    private void cancel() {
        this.returnOption = 2;
        this.setVisible(false);
    }
}

