/*
 * Decompiled with CFR 0.152.
 */
package com.rtfui.dialog;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class OpenList
extends JPanel
implements ListSelectionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private final JLabel lbTitle;
    private final JTextField tfText;
    private final JList<String> list;
    private final JScrollPane scrollPane;

    public OpenList(String[] stringArray, String string) {
        this.setLayout(null);
        this.lbTitle = new JLabel(string, 2);
        this.add(this.lbTitle);
        this.tfText = new JTextField();
        this.tfText.addActionListener(this);
        this.add(this.tfText);
        this.list = new JList<String>(stringArray);
        this.list.setVisibleRowCount(4);
        this.list.addListSelectionListener(this);
        this.scrollPane = new JScrollPane(this.list);
        this.add(this.scrollPane);
    }

    public void setSelected(String string) {
        this.list.setSelectedValue(string, true);
        this.tfText.setText(string);
    }

    public String getSelected() {
        return this.tfText.getText();
    }

    public void setSelectedInt(int n) {
        this.setSelected(Integer.toString(n));
    }

    public int getSelectedInt() {
        try {
            return Integer.parseInt(this.getSelected());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        String string = this.list.getSelectedValue();
        if (string != null) {
            this.tfText.setText(string.toString());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ListModel<String> listModel = this.list.getModel();
        String string = this.tfText.getText().toLowerCase();
        for (int i = 0; i < listModel.getSize(); ++i) {
            String string2 = listModel.getElementAt(i);
            if (!string2.toLowerCase().startsWith(string)) continue;
            this.list.setSelectedValue(string2, true);
            break;
        }
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.list.addListSelectionListener(listSelectionListener);
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        Dimension dimension = this.lbTitle.getPreferredSize();
        Dimension dimension2 = this.tfText.getPreferredSize();
        Dimension dimension3 = this.scrollPane.getPreferredSize();
        int n = Math.max(Math.max(dimension.width, dimension2.width), dimension3.width);
        int n2 = dimension.height + dimension2.height + dimension3.height;
        return new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
    }

    @Override
    public Dimension getMaximumSize() {
        Insets insets = this.getInsets();
        Dimension dimension = this.lbTitle.getMaximumSize();
        Dimension dimension2 = this.tfText.getMaximumSize();
        Dimension dimension3 = this.scrollPane.getMaximumSize();
        int n = Math.max(Math.max(dimension.width, dimension2.width), dimension3.width);
        int n2 = dimension.height + dimension2.height + dimension3.height;
        return new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
    }

    @Override
    public Dimension getMinimumSize() {
        Insets insets = this.getInsets();
        Dimension dimension = this.lbTitle.getMinimumSize();
        Dimension dimension2 = this.tfText.getMinimumSize();
        Dimension dimension3 = this.scrollPane.getMinimumSize();
        int n = Math.max(Math.max(dimension.width, dimension2.width), dimension3.width);
        int n2 = dimension.height + dimension2.height + dimension3.height;
        return new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
    }

    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = dimension.width - insets.left - insets.right;
        int n4 = dimension.height - insets.top - insets.bottom;
        Dimension dimension2 = this.lbTitle.getPreferredSize();
        this.lbTitle.setBounds(n, n2, n3, dimension2.height);
        Dimension dimension3 = this.tfText.getPreferredSize();
        this.tfText.setBounds(n, n2 += dimension2.height, n3, dimension3.height);
        this.scrollPane.setBounds(n, n2 += dimension3.height, n3, n4 - n2);
    }
}

