/*
 * Decompiled with CFR 0.152.
 */
package com.rtfui.dialog;

import com.rtfui.Messages;
import com.rtfui.dialog.ParagraphPreview;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class ParagraphDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JTextField tfLineSpacing;
    private final JTextField tfSpaceAbove;
    private final JTextField tfSpaceBelow;
    private final JTextField tfFirstIndent;
    private final JTextField tfLeftIndent;
    private final JTextField tfRightIndent;
    private final JToggleButton btLeft;
    private final JToggleButton btCenter;
    private final JToggleButton btRight;
    private final JToggleButton btJustified;
    private final ParagraphPreview preview;
    private int returnOption = -1;
    private MutableAttributeSet attributeSet;

    public ParagraphDialog(JFrame jFrame) {
        super(jFrame, Messages.getString("pd0"), true);
        this.setModal(true);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 2));
        JPanel jPanel2 = new JPanel(new GridLayout(3, 2, 10, 2));
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(), Messages.getString("pd1")));
        jPanel2.add(new JLabel(Messages.getString("pd2")));
        this.tfLineSpacing = new JTextField();
        jPanel2.add(this.tfLineSpacing);
        jPanel2.add(new JLabel(Messages.getString("pd3")));
        this.tfSpaceAbove = new JTextField();
        jPanel2.add(this.tfSpaceAbove);
        jPanel2.add(new JLabel(Messages.getString("pd4")));
        this.tfSpaceBelow = new JTextField();
        jPanel2.add(this.tfSpaceBelow);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new GridLayout(3, 2, 10, 2));
        jPanel3.setBorder(new TitledBorder(new EtchedBorder(), Messages.getString("pd5")));
        jPanel3.add(new JLabel(Messages.getString("pd6")));
        this.tfFirstIndent = new JTextField();
        jPanel3.add(this.tfFirstIndent);
        jPanel3.add(new JLabel(Messages.getString("pd7")));
        this.tfLeftIndent = new JTextField();
        jPanel3.add(this.tfLeftIndent);
        jPanel3.add(new JLabel(Messages.getString("pd8")));
        this.tfRightIndent = new JTextField();
        jPanel3.add(this.tfRightIndent);
        jPanel.add(jPanel3);
        this.getContentPane().add(jPanel);
        this.getContentPane().add(Box.createVerticalStrut(5));
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(new JLabel(Messages.getString("pd9")));
        jPanel.add(Box.createHorizontalStrut(20));
        ButtonGroup buttonGroup = new ButtonGroup();
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/icons/align-left.png"));
        this.btLeft = new JToggleButton(imageIcon);
        buttonGroup.add(this.btLeft);
        jPanel.add(this.btLeft);
        ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("/icons/align-center.png"));
        this.btCenter = new JToggleButton(imageIcon2);
        buttonGroup.add(this.btCenter);
        jPanel.add(this.btCenter);
        ImageIcon imageIcon3 = new ImageIcon(this.getClass().getResource("/icons/align-right.png"));
        this.btRight = new JToggleButton(imageIcon3);
        buttonGroup.add(this.btRight);
        jPanel.add(this.btRight);
        ImageIcon imageIcon4 = new ImageIcon(this.getClass().getResource("/icons/align-justify.png"));
        this.btJustified = new JToggleButton(imageIcon4);
        buttonGroup.add(this.btJustified);
        jPanel.add(this.btJustified);
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), Messages.getString("d3")));
        this.preview = new ParagraphPreview();
        jPanel.add((Component)this.preview, "Center");
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new FlowLayout());
        JPanel jPanel4 = new JPanel(new GridLayout(1, 2, 10, 2));
        JButton jButton = new JButton(Messages.getString("d1"));
        jButton.addActionListener(actionEvent -> this.confirm());
        jPanel4.add(jButton);
        JButton jButton2 = new JButton(Messages.getString("d2"));
        jButton2.addActionListener(actionEvent -> this.cancel());
        jPanel4.add(jButton2);
        jPanel.add(jPanel4);
        this.getContentPane().add(jPanel);
        this.pack();
        this.setResizable(false);
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ParagraphDialog.this.updatePreview();
            }
        };
        this.tfLineSpacing.addFocusListener(focusListener);
        this.tfSpaceAbove.addFocusListener(focusListener);
        this.tfSpaceBelow.addFocusListener(focusListener);
        this.tfFirstIndent.addFocusListener(focusListener);
        this.tfLeftIndent.addFocusListener(focusListener);
        this.tfRightIndent.addFocusListener(focusListener);
        ActionListener actionListener = actionEvent -> this.updatePreview();
        this.btLeft.addActionListener(actionListener);
        this.btCenter.addActionListener(actionListener);
        this.btRight.addActionListener(actionListener);
        this.btJustified.addActionListener(actionListener);
    }

    public void setAttributesph(AttributeSet attributeSet) {
        this.attributeSet = new SimpleAttributeSet(attributeSet);
        this.tfLineSpacing.setText(Float.toString(StyleConstants.getLineSpacing(attributeSet)));
        this.tfSpaceAbove.setText(Float.toString(StyleConstants.getSpaceAbove(attributeSet)));
        this.tfSpaceBelow.setText(Float.toString(StyleConstants.getSpaceBelow(attributeSet)));
        this.tfFirstIndent.setText(Float.toString(StyleConstants.getFirstLineIndent(attributeSet)));
        this.tfLeftIndent.setText(Float.toString(StyleConstants.getLeftIndent(attributeSet)));
        this.tfRightIndent.setText(Float.toString(StyleConstants.getRightIndent(attributeSet)));
        int n = StyleConstants.getAlignment(attributeSet);
        switch (n) {
            case 0: {
                this.btLeft.setSelected(true);
                break;
            }
            case 1: {
                this.btCenter.setSelected(true);
                break;
            }
            case 2: {
                this.btRight.setSelected(true);
                break;
            }
            case 3: {
                this.btJustified.setSelected(true);
                break;
            }
        }
        this.updatePreview();
    }

    public AttributeSet getAttributesph() {
        float f;
        if (this.attributeSet == null) {
            return null;
        }
        try {
            f = Float.parseFloat(this.tfLineSpacing.getText());
            StyleConstants.setLineSpacing(this.attributeSet, f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            f = Float.parseFloat(this.tfSpaceAbove.getText());
            StyleConstants.setSpaceAbove(this.attributeSet, f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            f = Float.parseFloat(this.tfSpaceBelow.getText());
            StyleConstants.setSpaceBelow(this.attributeSet, f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            f = Float.parseFloat(this.tfFirstIndent.getText());
            StyleConstants.setFirstLineIndent(this.attributeSet, f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            f = Float.parseFloat(this.tfLeftIndent.getText());
            StyleConstants.setLeftIndent(this.attributeSet, f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            f = Float.parseFloat(this.tfRightIndent.getText());
            StyleConstants.setRightIndent(this.attributeSet, f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        StyleConstants.setAlignment(this.attributeSet, this.getAlignment());
        return this.attributeSet;
    }

    public int getOption() {
        return this.returnOption;
    }

    private int getAlignment() {
        if (this.btLeft.isSelected()) {
            return 0;
        }
        if (this.btCenter.isSelected()) {
            return 1;
        }
        if (this.btRight.isSelected()) {
            return 2;
        }
        return 3;
    }

    private void updatePreview() {
        this.preview.updateAttributes(this.getAttributesph());
        this.preview.repaint();
    }

    private void confirm() {
        this.returnOption = 0;
        this.setVisible(false);
    }

    private void cancel() {
        this.returnOption = 2;
        this.setVisible(false);
    }
}

