/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.SwingViewBuilder;
import org.icepdf.ri.common.ToolbarLayout;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.util.PropertiesManager;

public class JRepSwingViewBuilder
extends SwingViewBuilder {
    JToggleButton showHideButton;

    public JRepSwingViewBuilder(SwingController swingController) {
        super(swingController, null, null, false, 2, null, 1, 1);
    }

    public void buildContents(Container container, boolean bl) {
        JSplitPane jSplitPane;
        container.setLayout(new BorderLayout());
        JToolBar jToolBar = this.buildCompleteToolBar(bl);
        if (jToolBar != null) {
            container.add((Component)jToolBar, "North");
        }
        if ((jSplitPane = this.buildUtilityAndDocumentSplitPane(bl)) != null) {
            container.add((Component)jSplitPane, "Center");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JRepSwingViewBuilder.this.showHideButton.doClick();
            }
        });
    }

    public JToolBar buildCompleteToolBar(boolean bl) {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setLayout((LayoutManager)new ToolbarLayout(0, 0, 0));
        this.commonToolBarSetup(jToolBar, true);
        this.doubleCheckPropertiesManager();
        this.addToToolBar(jToolBar, this.buildUtilityToolBar(bl, this.propertiesManager));
        this.addToToolBar(jToolBar, this.buildPageNavigationToolBar());
        this.addToToolBar(jToolBar, this.buildZoomToolBar());
        this.addToToolBar(jToolBar, this.buildFitToolBar());
        if (jToolBar.getComponentCount() == 0) {
            jToolBar = null;
        }
        if (this.viewerController != null && jToolBar != null) {
            this.viewerController.setCompleteToolBar(jToolBar);
        }
        return jToolBar;
    }

    public JToolBar buildUtilityToolBar(boolean bl, PropertiesManager propertiesManager) {
        JToolBar jToolBar = new JToolBar();
        this.commonToolBarSetup(jToolBar, false);
        this.showHideButton = this.buildShowHideUtilityPaneButton();
        this.addToToolBar(jToolBar, this.showHideButton);
        this.addToToolBar(jToolBar, this.buildSearchButton());
        if (jToolBar.getComponentCount() == 0) {
            return null;
        }
        return jToolBar;
    }

    public JSplitPane buildUtilityAndDocumentSplitPane(boolean bl) {
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setOneTouchExpandable(false);
        jSplitPane.setDividerSize(8);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setLeftComponent(this.buildUtilityTabbedPane());
        DocumentViewController documentViewController = this.viewerController.getDocumentViewController();
        this.viewerController.setIsEmbeddedComponent(bl);
        jSplitPane.getActionMap().getParent().remove("toggleFocus");
        jSplitPane.setRightComponent(documentViewController.getViewContainer());
        int n = PropertiesManager.checkAndStoreIntegerProperty((PropertiesManager)this.propertiesManager, (String)"application.divider.location", (int)160);
        jSplitPane.setDividerLocation(n);
        if (this.viewerController != null) {
            this.viewerController.setUtilityAndDocumentSplitPane(jSplitPane);
        }
        return jSplitPane;
    }
}

